<?php

namespace App\Filament\Resources\StoreSettings\Tables;

use Filament\Actions\ActionGroup;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class StoreSettingsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('اسم المتجر')
                    ->searchable()
                    ->sortable()
                    ->weight('bold'),

                IconColumn::make('active')
                    ->label('مفعّل')
                    ->boolean()
                    ->alignCenter(),

                TextColumn::make('updated_at')
                    ->label('آخر تحديث')
                    ->dateTime('Y-m-d H:i')
                    ->sortable(),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                ]),
            ])
            ->emptyStateHeading('لا توجد إعدادات')
            ->emptyStateDescription('قم بإنشاء إعدادات المتجر')
            ->emptyStateIcon('heroicon-o-building-storefront');
    }
}
