<?php

namespace App\Filament\Resources\Stickers;

use App\Filament\Resources\Stickers\Pages\CreateSticker;
use App\Filament\Resources\Stickers\Pages\EditSticker;
use App\Filament\Resources\Stickers\Pages\ListStickers;
use App\Filament\Resources\Stickers\Schemas\StickerForm;
use App\Filament\Resources\Stickers\Tables\StickersTable;
use App\Models\Sticker;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class StickerResource extends Resource
{
    protected static ?string $model = Sticker::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedSparkles;

    protected static ?string $navigationLabel = 'مكتبة الملصقات';

    protected static ?string $modelLabel = 'ملصق';

    protected static ?string $pluralModelLabel = 'الملصقات';

    protected static string|UnitEnum|null $navigationGroup = NavGroups::PRODUCTS;

    protected static ?int $navigationSort = 4;

    public static function form(Schema $schema): Schema
    {
        return StickerForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return StickersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListStickers::route('/'),
            'create' => CreateSticker::route('/create'),
            'edit' => EditSticker::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }

    public static function getNavigationBadge(): ?string
    {
        return (string) static::getModel()::where('status', 'pending')->count() ?: null;
    }

    public static function getNavigationBadgeColor(): string|array|null
    {
        return 'warning';
    }
}
