<?php

namespace App\Filament\Resources\ShippingAddresses\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class ShippingAddressForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            Section::make('معلومات العنوان')
                ->description('بيانات عنوان الشحن')
                ->icon('heroicon-o-map-pin')
                ->collapsible()
                ->columnSpanFull()
                ->schema([
                    Grid::make(2)->schema([
                        Select::make('client_id')
                            ->label('العميل')
                            ->relationship('client', 'name')
                            ->required()
                            ->searchable()
                            ->preload()
                            ->prefixIcon('heroicon-o-user'),

                        Select::make('city_id')
                            ->label('المدينة')
                            ->relationship('city', 'name')
                            ->searchable()
                            ->preload()
                            ->prefixIcon('heroicon-o-map'),

                        TextInput::make('name')
                            ->label('اسم المستلم')
                            ->required()
                            ->maxLength(255)
                            ->placeholder('الاسم الكامل')
                            ->prefixIcon('heroicon-o-user-circle'),

                        TextInput::make('phone')
                            ->label('رقم الهاتف')
                            ->tel()
                            ->required()
                            ->maxLength(20)
                            ->placeholder('07XXXXXXXXX')
                            ->prefixIcon('heroicon-o-phone'),

                        Textarea::make('address')
                            ->label('العنوان التفصيلي')
                            ->required()
                            ->rows(3)
                            ->placeholder('الحي، الشارع، رقم المنزل...')
                            ->columnSpanFull(),

                        Toggle::make('is_default')
                            ->label('العنوان الافتراضي')
                            ->default(false)
                            ->helperText('سيتم إلغاء العنوان الافتراضي السابق للعميل تلقائياً')
                            ->inline(false),
                    ]),
                ]),
        ]);
    }
}
