<?php

namespace App\Filament\Resources\Roles\Schemas;

use Illuminate\Support\Str;
use Filament\Schemas\Schema;
use App\Support\PermissionsLabel;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\CheckboxList;

class RolesForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make()
                    ->schema([
                        TextInput::make('name')
                            ->label('اسم الدور')
                            ->required()
                            ->columnSpanFull()
                            ->unique(ignoreRecord: true, table: 'roles'),

                        CheckboxList::make('permissions')
                            ->label('الصلاحيات')
                            ->relationship(
                                'permissions',          // اسم العلاقة
                                'name',                 // العمود المعروض من الجدول المرتبط
                                fn(Builder $query) => $query->orderBy('name') // تعديل الاستعلام
                            )
                            ->getOptionLabelFromRecordUsing(
                                fn(Permission $perm) => PermissionsLabel::label($perm->name)
                            )
                            ->columns(3)
                            ->searchable()
                            ->bulkToggleable()   // إن أعطاك خطأ، احذف هذا السطر حسب نسخة Filament
                            ->columnSpanFull()
                    ])
                    ->columns(2)->columnSpan('full')
            ]);
    }
}
