<?php

namespace App\Filament\Resources\Roles\Pages;

use App\Support\NavGroups;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Contracts\Support\Htmlable;
use App\Filament\Resources\Roles\RolesResource;

class EditRoles extends EditRecord
{
    protected static string $resource = RolesResource::class;

    // نخلي آخر جزء من breadcrumb ثابت "تعديل"
    protected static ?string $breadcrumb = 'تعديل';

    // اسم السجل كما يظهر في breadcrumb (مُترجم)
    public function getRecordTitle(): string|Htmlable
    {
        $name = (string) ($this->record->name ?? '');
        $key  = 'roles.' . $name;
        $t    = __($key);

        // fallback إذا ما لقي الترجمة
        return $t === $key ? $name : $t;
    }

    // العنوان الكبير أعلى الصفحة
    public function getHeading(): string|Htmlable
    {
        return 'تعديل ' . $this->getRecordTitle();
    }
}
