<?php

namespace App\Filament\Resources\Receipts;

use BackedEnum;
use App\Models\Receipt;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Receipts\Pages\EditReceipt;
use App\Filament\Resources\Receipts\Pages\ListReceipts;
use App\Filament\Resources\Receipts\Pages\PrintReceipt;
use App\Filament\Resources\Receipts\Pages\CreateReceipt;
use App\Filament\Resources\Receipts\Schemas\ReceiptForm;
use App\Filament\Resources\Receipts\Tables\ReceiptsTable;

class ReceiptResource extends Resource
{
    protected static ?string $model = Receipt::class;

    protected static string|BackedEnum|null $navigationIcon     = Heroicon::ReceiptPercent;
    protected static string|\UnitEnum|null   $navigationGroup   = NavGroups::Accounts;
    protected static ?string                  $navigationLabel  = 'الوصولات';
    protected static ?string                  $pluralModelLabel = 'الوصولات';
    protected static ?string                  $modelLabel       = '';
    protected static ?int $navigationSort                       = 41;
    protected static ?string $recordTitleAttribute              = 'number';

    public static function form(Schema $schema): Schema
    {
        return ReceiptForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ReceiptsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'     => ListReceipts::route('/'),
            'create'    => CreateReceipt::route('/create'),
            'edit'      => EditReceipt::route('/{record}/edit'),
            'print'     => PrintReceipt::route('/{record}/print'), // 🆕
        ];
    }
}
