<?php

namespace App\Filament\Resources\Receipts\Pages;

use App\Models\Receipt;
use Filament\Resources\Pages\Page;
use App\Filament\Resources\Receipts\ReceiptResource;

class PrintReceipt extends Page
{
    protected static string $resource = ReceiptResource::class;

    // ✅ طابق مكان الملف: resources/views/filament/pages/receipt.blade.php
    protected string $view = 'filament.pages.receipt';

    public Receipt $record;

    public function mount(Receipt $record): void
    {
        $this->record = $record->load([
            'client',
            'user',
            'vault',
            'lines' => fn($q) => $q->with(['installment', 'payable'])->orderBy('id'),
        ]);
    }

    public function getTitle(): string
    {
        return 'طباعة وصل';
    }

    public function getBreadcrumbs(): array
    {
        return [];
    }
}
