<?php

namespace App\Filament\Resources\Receipts\Pages;

use App\Filament\Resources\Receipts\ReceiptResource;
use Filament\Resources\Pages\CreateRecord;
use App\Models\Receipt;
use App\Models\Vault;
use Filament\Notifications\Notification;

class CreateReceipt extends CreateRecord
{
    protected static string $resource       = ReceiptResource::class;
    protected static ?string $breadcrumb    = 'إضافة';
    public function getBreadcrumbs(): array
    {
        return [
            route('filament.admin.pages.dashboard') => 'لوحة التحكم',
            ReceiptResource::getUrl()               => 'الوصولات',
            url()->current()                        => 'إضافة',
        ];
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // بيانات المستخدم والفرع
        $data['user_id']   = (int) user_info('id');
        $branchId          = (int) user_info('branch_id');
        $data['branch_id'] = $branchId;

        // خزنة الفرع (تُنشأ إن لم تكن موجودة)
        $vault = Vault::ensureForBranch($branchId);
        $data['vault_id'] = $vault->id;

        // رقم السند (تأكّد أن لديك Receipt::NUMBER_PREFIX و generateNumber() كما جهّزنا سابقًا)
        $data['number'] = Receipt::generateNumber($branchId);

        // طريقة الدفع الافتراضية إن لم تُمرَّر من الفورم
        $data['method'] = $data['method'] ?? 'cash';

        // تاريخ الدفع الافتراضي الآن إن لم يُرسل من الفورم
        $data['paid_at'] = $data['paid_at'] ?? now();

        // ملاحظات افتراضية خفيفة (اختياري)
        $data['notes'] = $data['notes'] ?? 'سند قبض جديد';

        // لا نملأ total_amount هنا؛ سيتم احتسابه بعد إضافة السطور
        $data['total_amount'] = 0;

        return $data;
    }

    protected function afterCreate(): void
    {
        Notification::make()
            ->title('تم إنشاء سند القبض')
            ->body('رقم السند: ' . ($this->record->number ?? ('#' . $this->record->id)))
            ->success()
            ->send();
    }

    protected function getRedirectUrl(): string
    {
        // نوجّه لصفحة التعديل كي تضيف سطور السند (ReceiptLines)
        return $this->getResource()::getUrl('edit', ['record' => $this->record]);
    }
}
