<?php

namespace App\Filament\Resources\Purchases\SupplierPayments;

use UnitEnum;
use BackedEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\SupplierPayment;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\Purchases\SupplierPayments\Pages\EditSupplierPayment;
use App\Filament\Resources\Purchases\SupplierPayments\Pages\ListSupplierPayments;
use App\Filament\Resources\Purchases\SupplierPayments\Pages\CreateSupplierPayment;
use App\Filament\Resources\Purchases\SupplierPayments\Schemas\SupplierPaymentForm;
use App\Filament\Resources\Purchases\SupplierPayments\Tables\SupplierPaymentsTable;

class SupplierPaymentResource extends Resource
{
    protected static ?string $model                         = SupplierPayment::class;
    protected static string|BackedEnum|null $navigationIcon = Heroicon::CurrencyDollar;
    protected static ?string $navigationLabel               = 'دفعة مورد';
    protected static ?string $modelLabel                    = 'دفعة مورد';
    protected static ?string $pluralModelLabel              = 'دفعات مورد';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::PURCHASES;
    protected static ?int $navigationSort                   = 73;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return SupplierPaymentForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return SupplierPaymentsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListSupplierPayments::route('/'),
            'create' => CreateSupplierPayment::route('/create'),
            'edit' => EditSupplierPayment::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
