<?php

namespace App\Filament\Resources\Purchases\SupplierPayments\Pages;

use App\Filament\Resources\Purchases\SupplierPayments\SupplierPaymentResource;
use App\Services\Payments\SupplierPaymentService;
use Filament\Actions\DeleteAction;
use Filament\Actions\ForceDeleteAction;
use Filament\Actions\RestoreAction;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Database\Eloquent\Model;

class EditSupplierPayment extends EditRecord
{
    protected static string $resource = SupplierPaymentResource::class;

    protected function handleRecordUpdate(Model $record, array $data): Model
    {
        return app(SupplierPaymentService::class)->update($record, $data);
    }

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make()
                ->before(function () {
                    app(SupplierPaymentService::class)->delete($this->record);
                }),

            ForceDeleteAction::make()
                ->before(function () {
                    app(SupplierPaymentService::class)->delete($this->record);
                }),

            RestoreAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
