<?php

namespace App\Filament\Resources\Purchases\SupplierPayments\Pages;

use App\Filament\Resources\Purchases\SupplierPayments\SupplierPaymentResource;
use App\Models\PurchaseInvoice;
use App\Services\Payments\SupplierPaymentService;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;

class CreateSupplierPayment extends CreateRecord
{
    protected static string $resource = SupplierPaymentResource::class;

    protected function handleRecordCreation(array $data): Model
    {
        // التحقق من وجود ديون
        $supplierId = $data['supplier_id'] ?? null;

        if ($supplierId) {
            $totalDue = $this->getSupplierDue((int) $supplierId);

            if ($totalDue <= 0) {
                Notification::make()
                    ->title('لا يمكن إنشاء الدفعة')
                    ->body('هذا المورد ليس عليه أي ديون مستحقة')
                    ->danger()
                    ->persistent()
                    ->send();

                $this->halt();
            }
        }

        return app(SupplierPaymentService::class)->create($data);
    }

    protected function getSupplierDue(int $supplierId): int
    {
        $data = PurchaseInvoice::where('supplier_id', $supplierId)
            ->selectRaw('COALESCE(SUM(total), 0) as total, COALESCE(SUM(paid), 0) as paid')
            ->first();

        return max(0, $data->total - $data->paid);
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('edit', ['record' => $this->record]);
    }
}
