<?php

namespace App\Filament\Resources\Purchases\PurchaseReturns;

use App\Filament\Resources\Purchases\PurchaseReturns\Pages\CreatePurchaseReturn;
use App\Filament\Resources\Purchases\PurchaseReturns\Pages\EditPurchaseReturn;
use App\Filament\Resources\Purchases\PurchaseReturns\Pages\ListPurchaseReturns;
use App\Filament\Resources\Purchases\PurchaseReturns\Schemas\PurchaseReturnForm;
use App\Filament\Resources\Purchases\PurchaseReturns\Tables\PurchaseReturnsTable;
use App\Models\PurchaseReturn;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class PurchaseReturnResource extends Resource
{
    protected static ?string $model                         = PurchaseReturn::class;
    protected static string|BackedEnum|null $navigationIcon = Heroicon::ArrowUturnLeft;
    protected static ?string $navigationLabel               = 'مرتجعات الشراء';
    protected static ?string $modelLabel                    = 'مرتجع شراء';
    protected static ?string $pluralModelLabel              = 'مرتجعات الشراء';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::PURCHASES;
    protected static ?int $navigationSort                   = 72;
    protected static ?string $recordTitleAttribute          = 'return_number';

    public static function form(Schema $schema): Schema
    {
        return PurchaseReturnForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PurchaseReturnsTable::configure($table);
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([SoftDeletingScope::class])
            ->with(['supplier', 'invoice', 'items']);
    }

    public static function getGloballySearchableAttributes(): array
    {
        return ['return_number', 'supplier.name', 'invoice.invoice_number'];
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListPurchaseReturns::route('/'),
            'create' => CreatePurchaseReturn::route('/create'),
            'edit'   => EditPurchaseReturn::route('/{record}/edit'),
        ];
    }
}
