<?php

namespace App\Filament\Resources\Purchases\PurchaseInvoices;

use BackedEnum;
use UnitEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\PurchaseInvoice;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\Purchases\PurchaseInvoices\Pages\EditPurchaseInvoice;
use App\Filament\Resources\Purchases\PurchaseInvoices\Pages\ViewPurchaseInvoice;
use App\Filament\Resources\Purchases\PurchaseInvoices\Pages\ListPurchaseInvoices;
use App\Filament\Resources\Purchases\PurchaseInvoices\Pages\CreatePurchaseInvoice;
use App\Filament\Resources\Purchases\PurchaseInvoices\Schemas\PurchaseInvoiceForm;
use App\Filament\Resources\Purchases\PurchaseInvoices\Tables\PurchaseInvoicesTable;
use App\Filament\Resources\Purchases\PurchaseInvoices\Schemas\PurchaseInvoiceInfolist;

class PurchaseInvoiceResource extends Resource
{
    protected static ?string $model = PurchaseInvoice::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::ClipboardDocumentList;
    protected static ?string $navigationLabel               = 'فاتورة شراء';
    protected static ?string $modelLabel                    = 'فاتورة ';
    protected static ?string $pluralModelLabel              = 'فاتورة شراء';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::PURCHASES;
    protected static ?int $navigationSort                   = 71;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return PurchaseInvoiceForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return PurchaseInvoiceInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PurchaseInvoicesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPurchaseInvoices::route('/'),
            'create' => CreatePurchaseInvoice::route('/create'),
            'view' => ViewPurchaseInvoice::route('/{record}'),
            'edit' => EditPurchaseInvoice::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
