<?php

namespace App\Filament\Resources\Purchases\PurchaseInvoices\Pages;

use App\Filament\Pages\Purchases\ImportPreview;
use App\Filament\Resources\Purchases\PurchaseInvoices\PurchaseInvoiceResource;
use App\Models\Supplier;
use App\Models\Warehouse;
use App\Services\Ocr\ImportPurchaseInvoice;
use Filament\Actions\Action;
use Filament\Actions\CreateAction;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Resources\Pages\ListRecords;

class ListPurchaseInvoices extends ListRecords
{
    protected static string $resource = PurchaseInvoiceResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make(), // زر "إضافة فاتورة"

            Action::make('importInvoice')
                ->label('استيراد')
                ->icon('heroicon-o-arrow-down-tray')
                ->color('gray')
                ->outlined()
                ->modalHeading('استيراد فاتورة (OCR)')
                ->modalSubmitActionLabel('تحليل')
                ->modalWidth('xl')
                ->schema([
                    FileUpload::make('file')
                        ->label('ملف الفاتورة (صورة/PDF)')
                        ->acceptedFileTypes(['application/pdf', 'image/*'])
                        ->required()
                        ->disk('upload')                               // ← القرص الذي عرّفناه
                        ->directory('purchases/invoices')              // ← مجلد نهائي (غير المؤقّت)
                        ->preserveFilenames()
                        ->visibility('public')
                        ->maxSize(25_000),

                    Select::make('ocr_engine')
                        ->label('محرك التحليل')
                        ->options([
                            'google' => 'Google Vision',
                            'azure' => 'Azure Read',
                            'aws' => 'AWS Textract',
                            'tesseract' => 'Tesseract (محلي)',
                        ])
                        ->default('tesseract')
                        ->native(false)
                        ->required(),

                    Select::make('lang')
                        ->label('اللغة')
                        ->options([
                            'ar' => 'العربية',
                            'en' => 'English',
                            'ar+en' => 'العربية + English',
                        ])
                        ->default('ar+en')
                        ->native(false)
                        ->required(),

                    Select::make('warehouse_id')
                        ->label('المستودع (اختياري)')
                        ->options(fn () => Warehouse::orderBy('name')->pluck('name', 'id'))
                        ->searchable()->preload()->native(false),

                    Select::make('supplier_id')
                        ->label('المورد (اختياري)')
                        ->options(fn () => Supplier::orderBy('name')->pluck('name', 'id'))
                        ->searchable()->preload()->native(false),
                ]),
            /*   ->action(function (array $data, $livewire) {
                    // 1) تحليل الملف عبر خدمة OCR
                    $jobResult = app(ImportPurchaseInvoice::class)->analyze(
                        filePath: $data['file'],
                        engine: $data['ocr_engine'],
                        lang: $data['lang'],
                    );

                    // 2) حفظ نتيجة التحليل مؤقتًا مع الافتراضات
                    session([
                        'import_purchase_invoice_preview' => $jobResult,
                        'import_defaults' => [
                            'warehouse_id' => $data['warehouse_id'] ?? null,
                            'supplier_id'  => $data['supplier_id'] ?? null,
                        ],
                    ]);

                    // 3) فتح صفحة المعاينة للمراجعة قبل الإنشاء
                    $livewire->redirect(ImportPreview::getUrl());
                }), */
        ];
    }
}
