<?php

namespace App\Filament\Resources\Products\Pages;

use App\Models\Product;
use Illuminate\Database\Eloquent\Model;
use Filament\Notifications\Notification;
use App\Services\Products\ProductService;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Resources\Products\ProductResource;

class CreateProduct extends CreateRecord
{
    protected static string $resource = ProductResource::class;

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('edit', ['record' => $this->record]);
    }

    protected function getCreatedNotificationTitle(): ?string
    {
        return 'تم إنشاء المنتج بنجاح';
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // يمكن إضافة معالجات إضافية هنا
        return $data;
    }

    protected function handleRecordCreation(array $data): Product
    {
        $service = app(ProductService::class);

        try {
            $product = $service->createOrUpdate(null, $data);

            Notification::make()
                ->success()
                ->title('تم إنشاء المنتج بنجاح')
                ->body("تم إنشاء المنتج \"{$product->name}\" مع " .
                    $product->variants()->count() . " نسخة")
                ->send();

            return $product;
        } catch (\Exception $e) {
            Notification::make()
                ->danger()
                ->title('خطأ في إنشاء المنتج')
                ->body($e->getMessage())
                ->persistent()
                ->send();

            throw $e;
        }
    }

    protected function afterCreate(): void
    {
        // معالجات إضافية بعد الإنشاء
        $product = $this->record;

        // مثال: تسجيل في الـ Log
        activity()
            ->performedOn($product)
            ->causedBy(user_info('id'))
            ->log('تم إنشاء منتج جديد: ' . $product->name);
    }
}
