<?php

namespace App\Filament\Resources\ProductPrices;

use App\Filament\Resources\ProductPrices\Pages\CreateProductPrices;
use App\Filament\Resources\ProductPrices\Pages\EditProductPrices;
use App\Filament\Resources\ProductPrices\Pages\ListProductPrices;
use App\Filament\Resources\ProductPrices\Pages\UpdateProductPrices;
use App\Filament\Resources\ProductPrices\Schemas\ProductPricesForm;
use App\Filament\Resources\ProductPrices\Tables\ProductPricesTable;
use App\Models\ProductPrice;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class ProductPricesResource extends Resource
{
    protected static ?string $model = ProductPrice::class;

    protected static string|\UnitEnum|null $navigationGroup = NavGroups::PRODUCTS;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::Wallet;

    protected static ?string $navigationLabel = 'الاسعار';

    protected static ?string $modelLabel = 'سعر المنتج';

    protected static ?string $pluralModelLabel = 'الاسعار';

    protected static ?int $navigationSort = 66;

    public static function form(Schema $schema): Schema
    {
        return ProductPricesForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ProductPricesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProductPrices::route('/'),
            'create' => CreateProductPrices::route('/create'),
            'edit' => EditProductPrices::route('/{record}/edit'),
            'bulk-update' => UpdateProductPrices::route('/bulk-update'),
        ];
    }
}
