<?php

namespace App\Filament\Resources\ProductModels\Tables;

use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteAction;
use Filament\Actions\RestoreAction;
use Filament\Actions\ViewAction;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\SpatieMediaLibraryImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;

class ProductModelsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                SpatieMediaLibraryImageColumn::make('preview')
                    ->label('المعاينة')
                    ->collection('model_preview')
                    ->circular()
                    ->defaultImageUrl(url('/images/placeholder.png'))
                    ->imageSize(50),

                TextColumn::make('name')
                    ->label('اسم الموديل')
                    ->searchable()
                    ->sortable()
                    ->weight('bold')
                    ->description(fn ($record) => $record->product?->name),

                TextColumn::make('product.name')
                    ->label('المنتج')
                    ->searchable()
                    ->sortable()
                    ->toggleable(),

                IconColumn::make('is_active')
                    ->label('نشط')
                    ->boolean()
                    ->sortable(),

                IconColumn::make('is_featured')
                    ->label('مميز')
                    ->boolean()
                    ->sortable(),

                TextColumn::make('views_count')
                    ->label('المشاهدات')
                    ->sortable()
                    ->color('gray')
                    ->icon(Heroicon::OutlinedEye),

                TextColumn::make('designs_count')
                    ->label('التصاميم')
                    ->sortable()
                    ->color('primary')
                    ->icon(Heroicon::OutlinedSparkles),

                TextColumn::make('order')
                    ->label('الترتيب')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime('Y-m-d h:i A')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('updated_at')
                    ->label('آخر تحديث')
                    ->dateTime('Y-m-d h:i A')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->recordActions([
                ActionGroup::make([
                    ViewAction::make()
                        ->url(fn ($record) => route('configurator.show', $record))
                        ->openUrlInNewTab()
                        ->label('معاينة في المتجر')
                        ->icon(Heroicon::OutlinedEye),
                    EditAction::make(),
                    DeleteAction::make(),
                    RestoreAction::make(),
                    ForceDeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->requiresConfirmation()
                        ->modalHeading('حذف الطلبات المحددة')
                        ->modalDescription('هل أنت متأكد من حذف الطلبات المحددة؟'),
                ]),
            ])
            ->defaultSort('order', 'asc')
            ->poll('30s');
    }
}
