<?php

namespace App\Filament\Resources\ProductModels;

use App\Filament\Resources\ProductModels\Pages\CreateProductModel;
use App\Filament\Resources\ProductModels\Pages\EditProductModel;
use App\Filament\Resources\ProductModels\Pages\ListProductModels;
use App\Filament\Resources\ProductModels\Schemas\ProductModelForm;
use App\Filament\Resources\ProductModels\Tables\ProductModelsTable;
use App\Models\ProductModel;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class ProductModelResource extends Resource
{
    protected static ?string $model = ProductModel::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedCube;

    protected static ?string $navigationLabel = 'الموديلات 3D';

    protected static ?string $modelLabel = 'موديل 3D';

    protected static ?string $pluralModelLabel = 'الموديلات 3D';

    protected static string|UnitEnum|null $navigationGroup = NavGroups::PRODUCTS;

    protected static ?int $navigationSort = 3;

    public static function form(Schema $schema): Schema
    {
        return ProductModelForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ProductModelsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProductModels::route('/'),
            'create' => CreateProductModel::route('/create'),
            'edit' => EditProductModel::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
