<?php

namespace App\Filament\Resources\ProductCards\Tables;

use App\Models\ProductCard;
use Filament\Actions\Action;
use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\TernaryFilter;
use Filament\Tables\Table;

class ProductCardsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('title')
                    ->label('الاسم')
                    ->searchable()
                    ->sortable()
                    ->wrap(),

                TextColumn::make('product.name')
                    ->label('المنتج')
                    ->sortable()
                    ->toggleable()
                    ->placeholder('—')
                    ->wrap(),

                TextColumn::make('variant.name')
                    ->label('المتغير')
                    ->toggleable()
                    ->placeholder('—')
                    ->wrap(),

                TextColumn::make('price')
                    ->label('السعر')
                    ->sortable()
                    ->alignEnd()
                    ->formatStateUsing(fn ($state) => number_format((int) $state).' د.ع'),

                IconColumn::make('show_discount')
                    ->label('خصم')
                    ->boolean()
                    ->toggleable(),

                TextColumn::make('discount_percent')
                    ->label('نسبة الخصم')
                    ->toggleable()
                    ->placeholder('—')
                    ->formatStateUsing(function ($state, ProductCard $record) {
                        if (! $record->show_discount) {
                            return '—';
                        }
                        $v = (int) ($state ?? 0);

                        return $v > 0 ? ($v.'%') : '—';
                    }),

                IconColumn::make('is_active')
                    ->label('نشط')
                    ->boolean()
                    ->sortable(),

                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime('Y-m-d h:i A')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                TernaryFilter::make('is_active')
                    ->label('الحالة')
                    ->trueLabel('نشط')
                    ->falseLabel('غير نشط')
                    ->placeholder('الكل'),

                TernaryFilter::make('show_discount')
                    ->label('خصم')
                    ->trueLabel('يوجد خصم')
                    ->falseLabel('بدون خصم')
                    ->placeholder('الكل'),

                SelectFilter::make('product_id')
                    ->label('المنتج')
                    ->relationship('product', 'name')
                    ->searchable()
                    ->preload(),
            ])
            ->recordActions([
                ActionGroup::make([
                    ViewAction::make(),
                    EditAction::make(),
                ]),

            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    Action::make('bulkPrintA6')
                        ->label('طباعة جماعية A6')
                        ->icon('heroicon-o-printer')
                        // ->action(function ($records) {
                        //     $ids = collect($records)
                        //         ->pluck('id')
                        //         ->map(fn($id) => (int) $id)
                        //         ->values()
                        //         ->all();

                        //     $query = implode(',', $ids);

                        //     return redirect()->to(route('product-cards.print.bulk', [
                        //         'ids' => $query,
                        //     ]));
                        // })
                        ->requiresConfirmation()
                        ->modalHeading('طباعة جماعية A6')
                        ->modalDescription('سيتم فتح صفحة طباعة تحتوي على جميع الكروت المحددة بقياس A6.')
                        ->modalSubmitActionLabel('متابعة'),

                    DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('id', 'desc');
    }
}
