<?php

namespace App\Filament\Resources\ProductCards\Schemas;

use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class ProductCardInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            Grid::make(2)->schema([
                Section::make('تفاصيل الكرت')
                    ->schema([
                        ImageEntry::make('image_url')
                            ->label('صورة المنتج')
                            ->height(180)
                            ->circular(false)
                            ->visibility('public')
                            ->hidden(fn ($record) => blank($record?->image_url)),

                        TextEntry::make('title')
                            ->label('اسم المنتج'),

                        TextEntry::make('description')
                            ->label('الوصف')
                            ->placeholder('—')
                            ->visible(fn ($record) => filled($record?->description))
                            ->extraAttributes([
                                'class' => 'text-sm text-gray-600',
                            ]),

                        TextEntry::make('formatted_price')
                            ->label('السعر'),

                        TextEntry::make('discount_percent')
                            ->label('نسبة الخصم')
                            ->visible(fn ($record) => (bool) ($record->has_discount ?? false))
                            ->formatStateUsing(fn ($state) => ((int) $state).'%'),

                        TextEntry::make('is_active')
                            ->label('الحالة')
                            ->formatStateUsing(fn ($state) => $state ? 'نشط' : 'غير نشط'),

                        TextEntry::make('notes')
                            ->label('الملاحظات')
                            ->placeholder('—')
                            ->visible(fn ($record) => filled($record?->notes))
                            ->extraAttributes([
                                'class' => 'text-sm text-gray-600',
                            ]),
                    ]),
            ]),
        ]);
    }
}
