<?php

namespace App\Filament\Resources\ProductCards;

use App\Filament\Resources\ProductCards\Pages\CreateProductCard;
use App\Filament\Resources\ProductCards\Pages\EditProductCard;
use App\Filament\Resources\ProductCards\Pages\ListProductCards;
use App\Filament\Resources\ProductCards\Pages\ViewProductCard;
use App\Filament\Resources\ProductCards\Schemas\ProductCardForm;
use App\Filament\Resources\ProductCards\Schemas\ProductCardInfolist;
use App\Filament\Resources\ProductCards\Tables\ProductCardsTable;
use App\Models\ProductCard;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class ProductCardResource extends Resource
{
    protected static ?string $model = ProductCard::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedIdentification;

    protected static ?string $navigationLabel = 'البطاقات';

    protected static ?string $modelLabel = 'بطاقة سعر';

    protected static ?string $pluralModelLabel = 'بطاقات الأسعار';

    protected static ?string $recordTitleAttribute = 'title';

    protected static string|UnitEnum|null $navigationGroup = NavGroups::PRODUCTS;

    protected static ?int $navigationSort = 66;

    public static function form(Schema $schema): Schema
    {
        return ProductCardForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ProductCardInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ProductCardsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProductCards::route('/'),
            'create' => CreateProductCard::route('/create'),
            'view' => ViewProductCard::route('/{record}'),
            'edit' => EditProductCard::route('/{record}/edit'),
        ];
    }
}
