<?php

namespace App\Filament\Resources\ProductCards\Pages;

use App\Filament\Resources\ProductCards\ProductCardResource;
use Filament\Actions\Action;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;

class ViewProductCard extends ViewRecord
{
    protected static string $resource = ProductCardResource::class;

    protected string $view = 'filament.pages.product.card';

    protected function getHeaderActions(): array
    {
        return [
            Action::make('back')
                ->label('العودة')
                ->icon('heroicon-o-arrow-right')
                ->url(ProductCardResource::getUrl('index')),

            EditAction::make(),
        ];
    }
}
