<?php

namespace App\Filament\Resources\Pos\Schemas;

use App\Models\Invoice;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class PosInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            TextEntry::make('invoice_number')
                ->label('رقم الفاتورة')
                ->placeholder('-'),

            TextEntry::make('client.name')
                ->label('العميل')
                ->placeholder('-'),

            TextEntry::make('sale_type')
                ->label('نوع البيع')
                ->placeholder('-'),

            TextEntry::make('grand_total')
                ->label('الصافي')
                ->placeholder('0'),

            TextEntry::make('paid_amount')
                ->label('المدفوع')
                ->placeholder('0'),

            TextEntry::make('due_amount')
                ->label('المتبقي')
                ->placeholder('0'),

            TextEntry::make('invoice_date')
                ->label('تاريخ الفاتورة')
                ->date()
                ->placeholder('-'),

            TextEntry::make('created_at')
                ->label('تاريخ الإنشاء')
                ->dateTime()
                ->placeholder('-'),

            TextEntry::make('deleted_at')
                ->label('محذوف في')
                ->dateTime()
                ->visible(fn (Invoice $record): bool => $record->trashed()),
        ]);
    }
}
