<?php

namespace App\Filament\Resources\Pos;

use App\Filament\Resources\Invoices\Pages\EditPos;
use App\Filament\Resources\Pos\Pages\CreatePos;
use App\Filament\Resources\Pos\Pages\ListPos;
use App\Filament\Resources\Pos\Pages\ViewPos;
use App\Filament\Resources\Pos\PosForm\PosForm;
use App\Filament\Resources\Pos\Schemas\PosInfolist;
use App\Filament\Resources\Pos\Tables\PosTable;
use App\Models\Invoice;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use UnitEnum;

class PosResource extends Resource
{
    protected static ?string $model = Invoice::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::DocumentCurrencyDollar;

    protected static string|UnitEnum|null $navigationGroup = NavGroups::SALES;

    protected static ?string $navigationLabel = 'البيع المباشر';

    protected static ?string $modelLabel = 'بيع مباشر';

    protected static ?string $pluralModelLabel = 'مبيعات مباشرة';

    protected static ?int $navigationSort = 50;

    protected static ?string $recordTitleAttribute = 'invoice_number';

    public static function form(Schema $schema): Schema
    {
        return PosForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return PosInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PosTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPos::route('/'),
            'create' => CreatePos::route('/create'),
            'view' => ViewPos::route('/{record}'),
            'edit' => EditPos::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
