<?php

namespace App\Filament\Resources\Pos\Pages;

use App\Filament\Resources\Pos\PosResource;
use App\Models\BranchSetting;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;

class ViewPos extends ViewRecord
{
    protected static string $resource = PosResource::class;

    // ✅ ربط الصفحة بقالب Blade مخصص للطباعة/العرض
    protected string $view = 'filament.pages.pos.view';

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
        ];
    }

    // ✅ إتاحة branchSetting للاستخدام في Blade
    public function getBranchSettingProperty()
    {
        return $this->record->branch->settings ?? new BranchSetting;
    }
}
