<?php

namespace App\Filament\Resources\Permissions\Schemas;

use Filament\Schemas\Schema;
use App\Support\PermissionsLabel;
use Illuminate\Support\HtmlString;
use Spatie\Permission\Models\Role;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\Placeholder;
use Filament\Schemas\Components\Utilities\Get;

class PermissionsForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            TextInput::make('name')
                ->label('اسم الصلاحية')
                ->required()
                ->unique(ignoreRecord: true, modifyRuleUsing: function ($rule, callable $get) {
                    return $rule->where('guard_name', $get('guard_name') ?? 'web');
                })
                ->reactive()
                ->hint(
                    fn(Get $get) =>
                    filled($get('name')) ? PermissionsLabel::label($get('name')) : null
                )
                ->hintColor('gray')
                // ->hintIcon('heroicon-m-language') // اختياري
                ->maxLength(190)
                ->columnSpanFull(),
            Placeholder::make('roles_preview')
                ->label('الأدوار المرتبطة حاليًا')
                ->content(function (?Permission $record) {
                    if (! $record) {
                        return new HtmlString('<span class="text-gray-500">—</span>');
                    }

                    // أسماء الأدوار مترجمة مع fallback
                    $names = $record->roles
                        ->pluck('name')
                        ->map(fn($n) => (__("roles.$n") !== "roles.$n") ? __("roles.$n") : $n);

                    if ($names->isEmpty()) {
                        return new HtmlString('<span class="text-gray-500">لا توجد أدوار مرتبطة</span>');
                    }

                    // خريطة ألوان بسيطة لكل دور (اختياري)
                    $colorFor = function (string $label): string {
                        return match ($label) {
                            'المسؤول'   => 'bg-blue-50 text-blue-700 border-blue-200',
                            'المدير'    => 'bg-amber-50 text-amber-700 border-amber-200',
                            'المحاسب'   => 'bg-emerald-50 text-emerald-700 border-emerald-200',
                            'المطعم'    => 'bg-slate-50 text-slate-700 border-slate-200',
                            'المصور'    => 'bg-rose-50 text-rose-700 border-rose-200',
                            default     => 'bg-gray-50 text-gray-700 border-gray-200',
                        };
                    };

                    // بناء حبّات (badges)
                    $badges = $names->map(function ($label) use ($colorFor) {
                        $cls = $colorFor($label);
                        return '<span class="inline-flex items-center rounded-full border ' . $cls . ' px-2.5 py-0.5 text-xs font-medium">'
                            . e($label) . '</span>';
                    })->implode(' ');

                    // حاوية مرنة بتباعد جميل
                    return new HtmlString('<div class="flex flex-wrap gap-1">' . $badges . '</div>');
                })
                ->columnSpanFull()
                ->hidden(fn($record) => ! $record) // ما يظهر في صفحة الإنشاء
        ]);
    }
}
