<?php

namespace App\Filament\Resources\Permissions;

use BackedEnum;
use UnitEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use Spatie\Permission\Models\Permission;
use App\Filament\Resources\Permissions\Pages\EditPermissions;
use App\Filament\Resources\Permissions\Pages\ListPermissions;
use App\Filament\Resources\Permissions\Pages\CreatePermissions;
use App\Filament\Resources\Permissions\Schemas\PermissionsForm;
use App\Filament\Resources\Permissions\Tables\PermissionsTable;

class PermissionsResource extends Resource
{
    protected static ?string $model = Permission::class;

    protected static string|BackedEnum|null $navigationIcon     = Heroicon::Key;
    protected static string|UnitEnum|null   $navigationGroup    = NavGroups::MEMBERS;
    protected static ?string $navigationLabel                   = 'الصلاحيات';
    protected static ?string $modelLabel                        = 'صلاحية';
    protected static ?string $pluralModelLabel                  = 'الصلاحيات';
    protected static ?int    $navigationSort                    = 15;
    protected static ?string $recordTitleAttribute              = 'name';

    public static function form(Schema $schema): Schema
    {
        return PermissionsForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PermissionsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'     => ListPermissions::route('/'),
            'create'    => CreatePermissions::route('/create'),
            'edit'      => EditPermissions::route('/{record}/edit'),
        ];
    }
}
