<?php

namespace App\Filament\Resources\Permissions\Pages;

use App\Support\PermissionsLabel;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Contracts\Support\Htmlable;
use App\Filament\Resources\Permissions\PermissionsResource;

class EditPermissions extends EditRecord
{
    protected static string $resource = PermissionsResource::class;

    // يجعل آخر جزء من الـ breadcrumb "تعديل"
    protected static ?string $breadcrumb = 'تعديل';

    // هذا يُستخدم لاسم السجل داخل الـ breadcrumb
    public function getRecordTitle(): string|Htmlable
    {
        return PermissionsLabel::label((string) $this->record->name);
    }

    // العنوان الكبير أعلى الصفحة
    public function getHeading(): string|Htmlable
    {
        return 'تعديل ' . $this->getRecordTitle();
    }
}
