<?php

namespace App\Filament\Resources\Payroll\Payrolls\Tables;

use Filament\Tables\Table;
use Filament\Actions\ViewAction;
use Filament\Actions\EditAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\TernaryFilter;
use App\Models\Payroll;

class PayrollsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            /* =========================
             * الأعمدة
             * ========================= */
            ->columns([
                TextColumn::make('employee.name')
                    ->label('الموظف')
                    ->searchable()
                    ->sortable()
                    ->weight('bold'),

                TextColumn::make('year')
                    ->label('السنة')
                    ->sortable()
                    ->alignCenter(),

                TextColumn::make('month')
                    ->label('الشهر')
                    ->sortable()
                    ->alignCenter(),

                TextColumn::make('net_salary')
                    ->label('صافي الراتب')
                    ->sortable()
                    ->alignEnd()
                    ->formatStateUsing(
                        fn(int $state): string => number_format($state)
                    ),

                IconColumn::make('is_paid')
                    ->label('مصروف')
                    ->boolean()
                    ->alignCenter(),
            ])

            /* =========================
             * الترتيب الافتراضي
             * ========================= */
            ->defaultSort('year', 'desc')
            ->defaultSort('month', 'desc')

            /* =========================
             * الفلاتر
             * ========================= */
            ->filters([
                // فلتر السنة
                SelectFilter::make('year')
                    ->label('السنة')
                    ->default(now()->year)
                    ->options(
                        fn() => Payroll::query()
                            ->select('year')
                            ->distinct()
                            ->orderByDesc('year')
                            ->pluck('year', 'year')
                            ->toArray()
                    ),

                // فلتر الشهر
                SelectFilter::make('month')
                    ->label('الشهر')
                    ->options([
                        1  => 'يناير',
                        2  => 'فبراير',
                        3  => 'مارس',
                        4  => 'أبريل',
                        5  => 'مايو',
                        6  => 'يونيو',
                        7  => 'يوليو',
                        8  => 'أغسطس',
                        9  => 'سبتمبر',
                        10 => 'أكتوبر',
                        11 => 'نوفمبر',
                        12 => 'ديسمبر',
                    ]),

                // فلتر حالة الصرف
                TernaryFilter::make('is_paid')
                    ->label('حالة الصرف')
                    ->trueLabel('مصروف')
                    ->falseLabel('غير مصروف')
                    ->placeholder('الكل'),
            ])

            /* =========================
             * أفعال السجل
             * ========================= */
            ->recordActions([
                ViewAction::make()
                    ->label('عرض'),

                EditAction::make()
                    ->label('تعديل'),
            ])

            /* =========================
             * الأفعال الجماعية
             * ========================= */
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->label('حذف'),
                ]),
            ]);
    }
}
