<?php

namespace App\Filament\Resources\Payroll\Payrolls\Schemas;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\DateTimePicker;

class PayrollForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('بيانات الراتب')
                    ->columnSpanFull()
                    ->schema([
                        Grid::make(12)
                            ->schema([
                                Select::make('employee_id')
                                    ->label('الموظف')
                                    ->relationship('employee', 'name')
                                    ->searchable()
                                    ->required()
                                    ->columnSpan(6),

                                Select::make('branch_id')
                                    ->label('الفرع')
                                    ->relationship('branch', 'name')
                                    ->required()
                                    ->columnSpan(6),

                                TextInput::make('year')
                                    ->label('السنة')
                                    ->numeric()
                                    ->rule('integer')
                                    ->required()
                                    ->columnSpan(4),

                                TextInput::make('month')
                                    ->label('الشهر')
                                    ->numeric()
                                    ->minValue(1)
                                    ->maxValue(12)
                                    ->rule('integer')
                                    ->required()
                                    ->columnSpan(4),

                                TextInput::make('base_salary')
                                    ->label('الراتب الأساسي')
                                    ->numeric()
                                    ->rule('integer')
                                    ->required()
                                    ->columnSpan(4),

                                TextInput::make('bonuses_total')
                                    ->label('إجمالي المكافآت')
                                    ->numeric()
                                    ->rule('integer')
                                    ->default(0)
                                    ->columnSpan(4),

                                TextInput::make('deductions_total')
                                    ->label('إجمالي الخصومات')
                                    ->numeric()
                                    ->rule('integer')
                                    ->default(0)
                                    ->columnSpan(4),

                                TextInput::make('net_salary')
                                    ->label('صافي الراتب')
                                    ->numeric()
                                    ->rule('integer')
                                    ->disabled()
                                    ->dehydrated()
                                    ->columnSpan(4),

                                Toggle::make('is_paid')
                                    ->label('تم الصرف')
                                    ->columnSpan(4),

                                DateTimePicker::make('paid_at')
                                    ->label('تاريخ الصرف')
                                    ->visible(fn($get) => $get('is_paid'))
                                    ->columnSpan(4),
                            ]),
                    ]),
            ]);
    }
}
