<?php

namespace App\Filament\Resources\Payroll\Payrolls;

use App\Filament\Resources\Payroll\Payrolls\Pages\CreatePayroll;
use App\Filament\Resources\Payroll\Payrolls\Pages\EditPayroll;
use App\Filament\Resources\Payroll\Payrolls\Pages\ListPayrolls;
use App\Filament\Resources\Payroll\Payrolls\Pages\ViewPayroll;
use App\Filament\Resources\Payroll\Payrolls\Schemas\PayrollForm;
use App\Filament\Resources\Payroll\Payrolls\Schemas\PayrollInfolist;
use App\Filament\Resources\Payroll\Payrolls\Tables\PayrollsTable;
use App\Models\Payroll;
use App\Support\NavGroups;
use BackedEnum;
use Filafly\Icons\Phosphor\Enums\Phosphor;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class PayrollResource extends Resource
{
    protected static ?string $model = Payroll::class;

    protected static string|BackedEnum|null $navigationIcon = Phosphor::ClipboardText;

    protected static ?string $navigationLabel = 'الرواتب';

    protected static ?string $modelLabel = 'راتب';

    protected static ?string $pluralModelLabel = 'الرواتب';

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Dues;

    protected static ?int $navigationSort = 25;

    public static function schema(Schema $schema): Schema
    {
        return PayrollForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return PayrollInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PayrollsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPayrolls::route('/'),
            'create' => CreatePayroll::route('/create'),
            'view' => ViewPayroll::route('/{record}'),
            'edit' => EditPayroll::route('/{record}/edit'),
        ];
    }
}
