<?php

namespace App\Filament\Resources\Payroll\PayrollRuns;

use UnitEnum;
use BackedEnum;
use App\Models\PayrollRun;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use Illuminate\Database\Eloquent\Builder;
use Filafly\Icons\Phosphor\Enums\Phosphor;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\Payroll\PayrollRuns\Pages\EditPayrollRun;
use App\Filament\Resources\Payroll\PayrollRuns\Pages\ViewPayrollRun;
use App\Filament\Resources\Payroll\PayrollRuns\Pages\ListPayrollRuns;
use App\Filament\Resources\Payroll\PayrollRuns\Pages\CreatePayrollRun;
use App\Filament\Resources\Payroll\PayrollRuns\Schemas\PayrollRunForm;
use App\Filament\Resources\Payroll\PayrollRuns\Tables\PayrollRunsTable;
use App\Filament\Resources\Payroll\PayrollRuns\Schemas\PayrollRunInfolist;

class PayrollRunResource extends Resource
{
    protected static ?string $model = PayrollRun::class;


    protected static string|BackedEnum|null $navigationIcon = Phosphor::HandCoins;
    protected static ?string $navigationLabel               = 'دفعات الرواتب';
    protected static ?string $modelLabel                    = 'دفعة الرواتب';
    protected static ?string $pluralModelLabel              = 'دفعات الرواتب';
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::Dues;
    protected static ?int $navigationSort                   = 26;

    public static function form(Schema $schema): Schema
    {
        return PayrollRunForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return PayrollRunInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PayrollRunsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPayrollRuns::route('/'),
            'create' => CreatePayrollRun::route('/create'),
            'view' => ViewPayrollRun::route('/{record}'),
            'edit' => EditPayrollRun::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
