<?php

namespace App\Filament\Resources\Payroll\PayrollDeductions;

use UnitEnum;
use BackedEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\PayrollDeduction;
use Filament\Actions\EditAction;
use Filament\Resources\Resource;
use Filament\Actions\DeleteAction;
use Filament\Support\Icons\Heroicon;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filafly\Icons\Phosphor\Enums\Phosphor;
use App\Filament\Resources\Payroll\PayrollDeductions\Pages\ManagePayrollDeductions;

class PayrollDeductionResource extends Resource
{
    protected static ?string $model                         = PayrollDeduction::class;
    protected static string|BackedEnum|null $navigationIcon = Phosphor::Siren;
    protected static ?string $navigationLabel               = 'الخصومات';
    protected static ?string $modelLabel                    = 'خصومة';
    protected static ?string $pluralModelLabel              = 'الخصومات';
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::Dues;
    protected static ?int $navigationSort                   = 28;

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => ManagePayrollDeductions::route('/'),
        ];
    }
}
