<?php

namespace App\Filament\Resources\Payroll\PayrollBonuses;

use UnitEnum;
use BackedEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use App\Models\PayrollBonus;
use Filament\Schemas\Schema;
use Filament\Actions\EditAction;
use Filament\Resources\Resource;
use Filament\Actions\DeleteAction;
use Filament\Support\Icons\Heroicon;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filafly\Icons\Phosphor\Enums\Phosphor;
use App\Filament\Resources\Payroll\PayrollBonuses\Pages\ManagePayrollBonuses;

class PayrollBonusResource extends Resource
{
    protected static ?string $model                         = PayrollBonus::class;
    protected static string|BackedEnum|null $navigationIcon = Phosphor::Trophy;
    protected static ?string $navigationLabel               = 'المكافآت';
    protected static ?string $modelLabel                    = 'مكافأة';
    protected static ?string $pluralModelLabel              = 'المكافآت';
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::Dues;
    protected static ?int $navigationSort                   = 27;

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => ManagePayrollBonuses::route('/'),
        ];
    }
}
