<?php

namespace App\Filament\Resources\PayGrades\Tables;

use Carbon\Carbon;
use Filament\Tables\Table;
use Filament\Actions\EditAction;
use Filament\Actions\ActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TernaryFilter;

class PayGradesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('الوظيفة')
                    ->badge()
                    ->searchable()
                    ->sortable(),
                TextColumn::make('amount')
                    ->label('الراتب الشهري')
                    ->badge()
                    ->color('danger')
                    ->state(fn($record) => (int) $record->amount)
                    ->formatStateUsing(fn($record) => number_format($record->amount))
                    ->suffix(' د.ع')
                    ->sortable(),
                IconColumn::make('is_active')
                    ->label('الحالة')
                    ->boolean()
                    ->sortable(),

                TextColumn::make('created_at')
                    ->label('أُنشئ في')
                    ->formatStateUsing(function ($state) {
                        if (! $state) return '—';

                        $dt = $state instanceof Carbon ? $state : Carbon::parse($state);
                        $dt = $dt->setTimezone('Asia/Baghdad'); // اختياري
                        $formatted = $dt->format('Y-m-d h:i A'); // 12 ساعة + AM/PM
                        return str_replace(['AM', 'PM'], ['ص', 'م'], $formatted);
                    })
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->label('آخر تحديث')
                    ->formatStateUsing(function ($state) {
                        if (! $state) return '—';

                        $dt = $state instanceof Carbon ? $state : Carbon::parse($state);
                        $dt = $dt->setTimezone('Asia/Baghdad'); // اختياري
                        $formatted = $dt->format('Y-m-d h:i A'); // 12 ساعة + AM/PM
                        return str_replace(['AM', 'PM'], ['ص', 'م'], $formatted);
                    })
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

            ])
            ->filters([
                TernaryFilter::make('is_active')
                    ->label('الحالة')
                    ->boolean()
                    ->trueLabel('فعّال')
                    ->falseLabel('متوقف'),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
