<?php

namespace App\Filament\Resources\PayGrades\Pages;

use App\Filament\Resources\PayGrades\PayGradeResource;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ManageRecords;

class ManagePayGrades extends ManageRecords
{
    protected static string $resource = PayGradeResource::class;

    /**
     * نحول أي إدخال amount (قد يكون فيه فواصل أو أرقام عربية) إلى int نظيف
     */
    private function normalizeAmount(null|string|int|float $value): int
    {
        // حوّل الأرقام العربية-الهندية إلى لاتينية
        $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩', '٫', '٬'];
        $latin  = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', ','];
        $str = strtr((string) ($value ?? ''), array_combine($arabic, $latin));

        // احذف كل ما ليس رقماً
        $digitsOnly = preg_replace('/\D+/', '', $str) ?: '0';

        // احذر من overflow إن احتجت (لكن عمودك INT)
        return (int) $digitsOnly;
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // إذا الحقل موجود في الفورم كنصي (بفواصل)، نظفه وضعه مكانه
        if (array_key_exists('amount', $data)) {
            $data['amount'] = $this->normalizeAmount($data['amount']);
        }

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if (array_key_exists('amount', $data)) {
            $data['amount'] = $this->normalizeAmount($data['amount']);
        }

        return $data;
    }

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make(),
        ];
    }
}
