<?php

namespace App\Filament\Resources\OvertimeRecords\Tables;

use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\TernaryFilter;
use Filament\Tables\Table;

class OvertimeRecordsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('employee.name')
                    ->label('الموظف')
                    ->sortable()
                    ->searchable()
                    ->weight('bold'),
                TextColumn::make('branch.name')
                    ->label('الفرع')
                    ->sortable()
                    ->toggleable(),
                TextColumn::make('date')
                    ->label('التاريخ')
                    ->date('Y-m-d')
                    ->sortable(),
                TextColumn::make('overtime_minutes')
                    ->label('دقائق إضافي')
                    ->alignEnd()
                    ->sortable(),
                TextColumn::make('overtime_amount')
                    ->label('المبلغ')
                    ->money('IQD', locale: 'ar')
                    ->alignEnd()
                    ->sortable(),
                IconColumn::make('is_approved')
                    ->label('معتمد')
                    ->boolean(),
                IconColumn::make('is_paid')
                    ->label('مدفوع')
                    ->boolean(),
            ])
            ->defaultSort('date', 'desc')
            ->filters([
                SelectFilter::make('branch_id')
                    ->label('الفرع')
                    ->relationship('branch', 'name')
                    ->visible(fn() => auth()->user()?->hasRole('admin')),
                SelectFilter::make('employee_id')
                    ->label('الموظف')
                    ->relationship('employee', 'name')
                    ->searchable(),
                TernaryFilter::make('is_approved')
                    ->label('معتمد'),
                TernaryFilter::make('is_paid')
                    ->label('مدفوع'),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
