<?php

namespace App\Filament\Resources\OvertimeRecords\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\DateTimePicker;

class OvertimeRecordForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('بيانات الوقت الإضافي')
                    ->schema([
                        Select::make('branch_id')
                            ->label('الفرع')
                            ->relationship('branch', 'name')
                            ->searchable()
                            ->preload()
                            ->required()
                            ->visible(fn() => auth()->user()?->hasRole('admin'))
                            ->default(
                                fn() => ! auth()->user()?->hasRole('admin')
                                    ? user_info('branch_id')
                                    : null
                            ),

                        Select::make('employee_id')
                            ->label('الموظف')
                            ->relationship('employee', 'name')
                            ->searchable()
                            ->preload()
                            ->required(),

                        Select::make('attendance_id')
                            ->label('سجل الحضور')
                            ->relationship('attendance', 'id')
                            ->searchable()
                            ->preload()
                            ->placeholder('اختياري'),

                        Select::make('work_schedule_id')
                            ->label('جدول الدوام')
                            ->relationship('workSchedule', 'name')
                            ->searchable()
                            ->preload()
                            ->placeholder('اختياري'),

                        DatePicker::make('date')
                            ->label('التاريخ')
                            ->native(false)
                            ->required(),

                        TextInput::make('overtime_minutes')
                            ->label('دقائق إضافي')
                            ->numeric()
                            ->required(),

                        TextInput::make('overtime_amount')
                            ->label('المبلغ')
                            ->numeric()
                            ->required(),

                        Toggle::make('is_approved')
                            ->label('معتمد')
                            ->default(false),

                        Toggle::make('is_paid')
                            ->label('مدفوع')
                            ->default(false),

                        DateTimePicker::make('approved_at')
                            ->label('تاريخ الاعتماد')
                            ->native(false)
                            ->seconds(false),

                        Select::make('approved_by')
                            ->label('اعتمد بواسطة')
                            ->relationship('approvedByUser', 'name')
                            ->searchable()
                            ->preload()
                            ->placeholder('اختياري'),

                        DateTimePicker::make('paid_at')
                            ->label('تاريخ الدفع')
                            ->native(false)
                            ->seconds(false),

                        Textarea::make('notes')
                            ->label('ملاحظات')
                            ->columnSpanFull(),
                    ])
                    ->columns(2)
                    ->columnSpanFull(),
            ]);
    }
}
