<?php

namespace App\Filament\Resources\OvertimeRecords;

use App\Models\OvertimeRecord;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;
use App\Filament\Resources\OvertimeRecords\Tables\OvertimeRecordsTable;
use App\Filament\Resources\OvertimeRecords\Schemas\OvertimeRecordForm;
use App\Filament\Resources\OvertimeRecords\Pages\ListOvertimeRecords;
use App\Filament\Resources\OvertimeRecords\Pages\CreateOvertimeRecord;
use App\Filament\Resources\OvertimeRecords\Pages\EditOvertimeRecord;

class OvertimeRecordResource extends Resource
{
    protected static ?string $model = OvertimeRecord::class;
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static ?string $navigationLabel = 'سجلات الوقت الإضافي';
    protected static ?string $modelLabel = 'وقت إضافي';
    protected static ?string $pluralModelLabel = 'سجلات الوقت الإضافي';
    protected static string|UnitEnum|null $navigationGroup = NavGroups::MEMBERS;
    protected static ?int $navigationSort = 16;

    public static function form(Schema $schema): Schema
    {
        return OvertimeRecordForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return OvertimeRecordsTable::configure($table);
    }

    public static function getPages(): array
    {
        return [
            'index' => ListOvertimeRecords::route('/'),
            'create' => CreateOvertimeRecord::route('/create'),
            'edit' => EditOvertimeRecord::route('/{record}/edit'),
        ];
    }
}
