<?php

namespace App\Filament\Resources\Orders\Pages;

use App\Enums\OrderStatus;
use App\Filament\Resources\Orders\OrderResource;
use Filament\Actions\Action;
use Filament\Actions\EditAction;
use Filament\Resources\Pages\ViewRecord;

class ViewOrder extends ViewRecord
{
    protected static string $resource = OrderResource::class;

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),

            Action::make('confirm')
                ->label('تأكيد الطلب')
                ->icon('heroicon-o-check-circle')
                ->color('success')
                ->requiresConfirmation()
                ->modalHeading('تأكيد الطلب')
                ->modalDescription('هل أنت متأكد من تأكيد هذا الطلب؟')
                ->visible(fn () => $this->record->status === OrderStatus::Pending)
                ->action(function () {
                    $this->record->confirm();
                    $this->refreshFormData(['status']);
                }),

            Action::make('cancel')
                ->label('إلغاء الطلب')
                ->icon('heroicon-o-x-circle')
                ->color('danger')
                ->requiresConfirmation()
                ->modalHeading('إلغاء الطلب')
                ->modalDescription('هل أنت متأكد من إلغاء هذا الطلب؟')
                ->visible(fn () => $this->record->is_cancelable)
                ->action(function () {
                    $this->record->cancel();
                    $this->refreshFormData(['status']);
                }),
        ];
    }
}
