<?php

namespace App\Filament\Resources\Inventory\Warehouses;

use UnitEnum;
use BackedEnum;
use App\Models\Warehouse;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\Inventory\Warehouses\Pages\EditWarehouse;
use App\Filament\Resources\Inventory\Warehouses\Pages\ViewWarehouse;
use App\Filament\Resources\Inventory\Warehouses\Pages\ListWarehouses;
use App\Filament\Resources\Inventory\Warehouses\Pages\CreateWarehouse;
use App\Filament\Resources\Inventory\Warehouses\Schemas\WarehouseForm;
use App\Filament\Resources\Inventory\Warehouses\Tables\WarehousesTable;
use App\Filament\Resources\Inventory\Warehouses\Schemas\WarehouseInfolist;

class WarehouseResource extends Resource
{
    protected static ?string $model = Warehouse::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::BuildingOffice;
    protected static ?string $navigationLabel               = 'المستودعات';
    protected static ?string $modelLabel                    = 'مستودع';
    protected static ?string $pluralModelLabel              = 'المستودعات';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::STOCK_IN;
    protected static ?int $navigationSort                   = 80;
    protected static ?string $recordTitleAttribute          = 'name';


    public static function getEloquentQuery(): Builder
    {
        $query = parent::getEloquentQuery()->withoutGlobalScopes([SoftDeletingScope::class]);
        if ($user = Auth::user()) {
            return $query->where('city_id', $user->branch->city_id);
        }

        // ضيف: لا تعرض شيئًا
        return $query->whereRaw('1 = 0');
    }
    public static function form(Schema $schema): Schema
    {
        return WarehouseForm::configure($schema);
    }


    public static function table(Table $table): Table
    {
        return WarehousesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListWarehouses::route('/'),
            'create' => CreateWarehouse::route('/create'),
            'edit' => EditWarehouse::route('/{record}/edit'),
        ];
    }
}
