<?php

namespace App\Filament\Resources\Inventory\Warehouses\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Illuminate\Support\Facades\Auth;
use Filament\Forms\Components\Hidden;

class WarehouseForm
{
    // helper بسيط:
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('بيانات المستودع')->schema([
                    Grid::make(12)->schema([
                        TextInput::make('name')
                            ->label('اسم المستودع')
                            ->required()->maxLength(150)
                            ->columnSpan(6),
                        // يظهر فقط للـ admin:
                        Select::make('city_id')
                            ->label('المدينة')
                            ->relationship('city', 'name')
                            ->required()
                            ->searchable()->preload()->native(false)
                            ->default(fn() => Auth::user()?->branch?->city_id)
                            ->visible(fn() => user_info()->admin() === true)
                            ->columnSpan(6),
                    ]),

                    Grid::make(12)->schema([
                        Toggle::make('is_active')
                            ->label('نشط')->default(true)->inline(false)->columnSpan(6),
                    ]),

                ])->columnSpanFull(),
            ]);
    }
}
