<?php

namespace App\Filament\Resources\Inventory\Warehouses\Pages;

use App\Filament\Resources\Inventory\Warehouses\WarehouseResource;
use App\Models\Branch;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditWarehouse extends EditRecord
{
    protected static string $resource = WarehouseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // 1) ضمان وجود city_id لو كان فاضي (حالات داتا قديمة مثلاً)
        if (empty($data['city_id'])) {
            $branchId = user_info('branch_id');

            if ($branchId) {
                $branch = Branch::find($branchId);

                if ($branch && $branch->city_id) {
                    $data['city_id'] = $branch->city_id;
                }
            }
        }

        // 2) ضمان وجود user_id لو كان فاضي
        if (empty($data['user_id'])) {
            $data['user_id'] = user_info('id');
        }

        return $data;
    }
}
