<?php

namespace App\Filament\Resources\Inventory\Warehouses\Pages;

use App\Filament\Resources\Inventory\Warehouses\WarehouseResource;
use App\Models\Branch;
use Filament\Resources\Pages\CreateRecord;

class CreateWarehouse extends CreateRecord
{
    protected static string $resource = WarehouseResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // 1) ضبط المدينة من فرع المستخدم الحالي إذا لم تُرسل من الفورم
        if (empty($data['city_id'])) {
            $branchId = user_info('branch_id');

            if ($branchId) {
                $branch = Branch::find($branchId);

                if ($branch && $branch->city_id) {
                    $data['city_id'] = $branch->city_id;
                }
            }
        }

        // 2) ضبط user_id من الدالة إذا لم يُرسل من الفورم
        if (empty($data['user_id'])) {
            // غيّر 'id' إلى 'user_id' لو دالتك ترجعها بهذا الاسم
            $data['user_id'] = user_info('id');
        }

        return $data;
    }
}
