<?php

namespace App\Filament\Resources\Inventory\StockMovements;

use BackedEnum;
use UnitEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\StockMovement;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Inventory\StockMovements\Pages\ListStockMovements;
use App\Filament\Resources\Inventory\StockMovements\Pages\CreateStockMovement;
use App\Filament\Resources\Inventory\StockMovements\Schemas\StockMovementForm;
use App\Filament\Resources\Inventory\StockMovements\Tables\StockMovementsTable;

class StockMovementResource extends Resource
{
    protected static ?string $model = StockMovement::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static ?string $navigationLabel               = 'حركات المخزون';
    protected static ?string $modelLabel                    = 'حركة مخزون';
    protected static ?string $pluralModelLabel              = 'حركات المخزون';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::STOCK_IN;
    protected static ?int $navigationSort                   = 83;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return StockMovementForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return StockMovementsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }
    public static function canGloballySearch(): bool
    {
        return false;
    }
    public static function getPages(): array
    {
        return [
            'index' => ListStockMovements::route('/'),
            // 'create' => CreateStockMovement::route('/create'),
        ];
    }
}
