<?php

namespace App\Filament\Resources\Inventory\StockBalances;

use BackedEnum;
use UnitEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use App\Models\StockBalance;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Inventory\StockBalances\Pages\EditStockBalance;
use App\Filament\Resources\Inventory\StockBalances\Pages\ListStockBalances;
use App\Filament\Resources\Inventory\StockBalances\Pages\CreateStockBalance;
use App\Filament\Resources\Inventory\StockBalances\Schemas\StockBalanceForm;
use App\Filament\Resources\Inventory\StockBalances\Tables\StockBalancesTable;

class StockBalanceResource extends Resource
{
    protected static ?string $model = StockBalance::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static ?string $navigationLabel               = 'المخزون الحالي';
    protected static ?string $modelLabel                    = 'رصيد مخزون';
    protected static ?string $pluralModelLabel              = 'أرصدة المخزون';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::STOCK_IN;
    protected static ?int $navigationSort                   = 82;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return StockBalanceForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return StockBalancesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }
    public static function canGloballySearch(): bool
    {
        return false;
    }

    public static function getPages(): array
    {
        return [
            'index' => ListStockBalances::route('/'),
            // 'create' => CreateStockBalance::route('/create'),
            // 'edit' => EditStockBalance::route('/{record}/edit'),
        ];
    }
}
