<?php

namespace App\Filament\Resources\Inventory\BranchWarehouses\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Components\Section;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Hidden;

class BranchWarehouseForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            Section::make('بيانات الربط')
                ->schema([

                    Select::make('branch_id')
                        ->label('الفرع')
                        ->relationship('branch', 'name')
                        ->searchable()
                        ->preload()
                        ->required()
                        ->native(false)
                        ->prefixIcon('phosphor-storefront-duotone'),

                    Select::make('warehouse_id')
                        ->label('المستودع')
                        ->relationship('warehouse', 'name')
                        ->searchable()
                        ->preload()
                        ->required()
                        ->native(false)
                        ->prefixIcon('phosphor-factory-duotone'),

                    DatePicker::make('assigned_at')
                        ->label('تاريخ الربط')
                        ->native(false)
                        ->displayFormat('Y-m-d')
                        ->default(now())
                        ->prefixIcon('phosphor-calendar-blank-duotone')
                        ->closeOnDateSelection(),

                    // يظهر فقط عند التعديل وليس عند الإنشاء
                    DatePicker::make('unassigned_at')
                        ->label('تاريخ فك الربط')
                        ->native(false)
                        ->displayFormat('Y-m-d')
                        ->prefixIcon('phosphor-calendar-x-duotone')
                        ->nullable()
                        ->closeOnDateSelection()
                        ->visible(fn($livewire) => $livewire instanceof \Filament\Resources\Pages\EditRecord),
                ])
                ->columnSpanFull()
                ->columns(2),
        ]);
    }
}
