<?php

namespace App\Filament\Resources\Inventory\BranchWarehouses\Pages;

use App\Models\BranchWarehouse;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Resources\Inventory\BranchWarehouses\BranchWarehouseResource;

class EditBranchWarehouse extends EditRecord
{
    protected static string $resource = BranchWarehouseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // في حال أصبح هذا السجل هو الافتراضي
        if (!empty($data['is_primary']) && $data['is_primary'] == true) {
            BranchWarehouse::where('branch_id', $data['branch_id'])
                ->where('id', '!=', $this->record->id)
                ->update(['is_primary' => false]);
        }

        return $data;
    }
}
