<?php

namespace App\Filament\Resources\Inventory\BranchWarehouses\Pages;

use App\Models\BranchWarehouse;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Resources\Inventory\BranchWarehouses\BranchWarehouseResource;

class CreateBranchWarehouse extends CreateRecord
{
    protected static string $resource = BranchWarehouseResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // ضبط تاريخ الربط افتراضياً
        $data['assigned_at'] ??= now();

        // إن كان السجل افتراضي، نزيل الافتراضية عن كل المستودعات السابقة لنفس الفرع
        if (!empty($data['is_primary']) && $data['is_primary'] == true) {
            BranchWarehouse::where('branch_id', $data['branch_id'])
                ->update(['is_primary' => false]);
        }

        return $data;
    }
}
