<?php

namespace App\Filament\Resources\Inventory\BranchWarehouses;

use UnitEnum;
use BackedEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\BranchWarehouse;
use Filament\Resources\Resource;
use Filafly\Icons\Phosphor\Enums\Phosphor;
use App\Filament\Resources\Inventory\BranchWarehouses\Pages\EditBranchWarehouse;
use App\Filament\Resources\Inventory\BranchWarehouses\Pages\ListBranchWarehouses;
use App\Filament\Resources\Inventory\BranchWarehouses\Pages\CreateBranchWarehouse;
use App\Filament\Resources\Inventory\BranchWarehouses\Schemas\BranchWarehouseForm;
use App\Filament\Resources\Inventory\BranchWarehouses\Tables\BranchWarehousesTable;

class BranchWarehouseResource extends Resource
{
    protected static ?string $model                         = BranchWarehouse::class;
    protected static string|BackedEnum|null $navigationIcon = Phosphor::Warehouse;
    protected static ?string $navigationLabel               = 'إدارة مستودعات الفروع';
    protected static ?string $modelLabel                    = 'مستودع فرع';
    protected static ?string $pluralModelLabel              = ' إدارة مستودعات الفروع';
    protected static string|UnitEnum|null $navigationGroup  = NavGroups::STOCK_IN;
    protected static ?int $navigationSort                   = 81;


    public static function form(Schema $schema): Schema
    {
        return BranchWarehouseForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BranchWarehousesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'     => ListBranchWarehouses::route('/'),
            'create'    => CreateBranchWarehouse::route('/create'),
            'edit'      => EditBranchWarehouse::route('/{record}/edit'),
        ];
    }
}
